;--------------------------------------------------------------
; This script sends clipboard text as keystrokes with Ctrl+Shift+V.
; Useful when native paste doesn't work (e.g. SSH, RDP).
; Features:
;  - Shows a tooltip if the clipboard is empty.
;  - Adjustable SetKeyDelay for terminals that need slower input.
;  - Does NOT override normal Ctrl+V.
;--------------------------------------------------------------

; Adjust key delay here (ms between keys, ms press duration):
SetKeyDelay(20, 20)   ; Increase delay if remote session drops characters

^+v::  ; Ctrl + Shift + V
{
    if (A_Clipboard = "") {
        ; Clipboard empty – show a quick notification
        Tooltip, ⚠️ Clipboard is empty!
        SetTimer, RemoveTooltip, -1500
        return
    }
    Send(A_Clipboard)
}
return

RemoveTooltip:
Tooltip
return
