#!/bin/bash

# Update packages, install essentials
sudo apt update
sudo apt install -y build-essential git zsh htop tmux

# Install: oh-my-zsh
sh -c "$(curl -fsSL https://raw.github.com/robbyrussell/oh-my-zsh/master/tools/install.sh)"

# Install Powerlevel10k
git clone --depth=1 https://github.com/romkatv/powerlevel10k.git "${ZSH_CUSTOM:-$HOME/.oh-my-zsh/custom}/themes/powerlevel10k"
sed -i -- 's/ZSH_THEME="robbyrussell"/plugins=(virtualenv)\nPOWERLEVEL9K_CUSTOM_LIVE_BACKGROUND="red"\nPOWERLEVEL9K_CUSTOM_LIVE_FOREGROUND="white"\nPOWERLEVEL9K_MODE="nerdfont-complete"\nPOWERLEVEL9K_LEFT_PROMPT_ELEMENTS=(custom_live host dir vcs virtualenv)\nPOWERLEVEL9K_RIGHT_PROMPT_ELEMENTS=(status root_indicator background_jobs load ram disk_usage time)\nZSH_THEME="powerlevel10k\/powerlevel10k"\n/g' ~/.zshrc

# zsh-syntax-highlighting
sudo apt install zsh-syntax-highlighting 
echo "source /usr/share/zsh-syntax-highlighting/zsh-syntax-highlighting.zsh" >> ${ZDOTDIR:-$HOME}/.zshrc

# zsh-autosuggestions
git clone https://github.com/zsh-users/zsh-autosuggestions ${ZSH_CUSTOM:-~/.oh-my-zsh/custom}/plugins/zsh-autosuggestions
sed -i -- 's/^plugins=(/plugins=(\n  zsh-autosuggestions\n/g' ~/.zshrc

# Install: timss/vimconf (https://github.com/timss/vimconf#installation)
sudo apt install -y vim exuberant-ctags
mkdir -p ~/.vim/vimconf
git clone https://github.com/timss/vimconf.git ~/.vim/vimconf
ln -s ~/.vim/vimconf/.vimrc ~/.vimrc

# Add user to sudoers with no password
echo "$USER ALL=(ALL) NOPASSWD: ALL" | sudo tee /etc/sudoers.d/$USER
sudo chmod 440 /etc/sudoers.d/$USER

# Install public key
KEY="ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAILB5bVuBHYwgtCL+ppoOkKSpu/+wmSOt80yVE/S2qU0F"
mkdir -p ~/.ssh && chmod 700 ~/.ssh && echo "$KEY" >> ~/.ssh/authorized_keys && chmod 600 ~/.ssh/authorized_keys
