# **Ubuntu Development Environment Setup Script**

This bash script automatically configures a comprehensive development environment on Ubuntu/Debian systems. Here's what it accomplishes:

## Installation

### Curl

```sh
curl -fsSL https://opengist.internal.willithiel.net/wthiel/032ceca594884fce86ed8a6a32726bd2/raw/HEAD/bootstrap.sh | bash
```

### wget

```sh
wget -qO- https://opengist.internal.willithiel.net/wthiel/032ceca594884fce86ed8a6a32726bd2/raw/HEAD/bootstrap.sh | bash
```

## **System Updates & Essential Tools**
- Updates package repositories
- Installs core development tools: `build-essential`, `git`, `zsh`, `htop`, `tmux`

## **Advanced Shell Configuration**
| Component | Purpose | Configuration |
|-----------|---------|---------------|
| **Oh My Zsh** | Enhanced Zsh framework | Installs from official repository |
| **Powerlevel10k** | Advanced shell theme | Custom prompt with host, directory, git status, virtualenv |
| **Syntax Highlighting** | Command syntax coloring | System package installation |
| **Auto-suggestions** | Command completion | Plugin integration |

## **Vim Editor Enhancement**
- Installs Vim with `exuberant-ctags` support
- Deploys `timss/vimconf` configuration for enhanced editing experience
- Creates symbolic links for configuration files

## **Security & Access Configuration**
- **Passwordless Sudo**: Grants the current user unrestricted sudo access without password prompts
- **SSH Key Installation**: Adds a predefined Ed25519 public key to `authorized_keys` for remote access
- Sets appropriate file permissions (700 for `.ssh`, 600 for `authorized_keys`)

## **Key Features**
- **Automated Setup**: Complete hands-off installation
- **Developer-Focused**: Tools optimized for coding and system administration
- **Security Integration**: SSH key deployment for remote access
- **Shell Customization**: Modern, feature-rich terminal experience
